<html>
<head>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.0/css/bootstrap.min.css">
</head>
<body>
<div id="app" class="p-4">

    <!-- 画像入力 -->
    <label class="btn btn-primary">
        画像を選択してアップロード
        <input class="d-none" type="file" accept="image/jpeg,image/png" @change="onFileChange">
    </label>
    <br>

    <!-- 画像を表示 -->
    <v-webp
        :src="imageUrls.webp"
        :original-src="imageUrls.jpg">
    </v-webp>

</div>
<script src="https://unpkg.com/vue@3.0.2/dist/vue.global.prod.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/axios/0.19.2/axios.min.js"></script>
<script>

    const webpComponent = {
        props: ['src', 'original-src'],
        template: `
            <picture>
                <source :srcset="src" type="image/webp">
                <source :srcset="originalSrc" type="image/jpeg">
                <img :src="originalSrc">
            </picture>
        `
    };

    Vue.createApp({
        data() {
            return {
                imageUrls: {
                    webp: '',
                    jpg: ''
                }
            }
        },
        methods: {
            onFileChange(e) {

              const files = e.target.files;

              if(files.length > 0) {

                  const file = files[0];
                  const url = '{{ route('upload_image.store') }}';
                  let formData = new FormData();
                  formData.append('image', file);

                  axios.post(url, formData)
                    .then(response => {

                        if(response.data.result === true) {

                            // アップロードが成功
                            this.imageUrls = response.data.image_urls;

                        }

                    })
                    .catch(error => {

                        console.log(error);

                    });

              }

            }
        }
    })
    .component('v-webp', webpComponent)
    .mount('#app');

</script>
</body>
</html>
